/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.util;

import java.io.IOException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarInfo {
    private Manifest manifest = null;
    public static final String ATTRIBUTE_VERSION = "Implementation-Version";
    public static final String ATTRIBUTE_TITLE = "Implementation-Title";
    public static final String ATTRIBUTE_BUILDNUMBER = "Implementation-Buildnumber";
    public static final String ATTRIBUTE_BUILDDATE = "Built-Date";

    public JarInfo(JarFile jar) throws IOException {
        this.manifest = jar.getManifest();
    }

    public String getAttribute(String name) {
        return this.manifest.getMainAttributes().getValue(name);
    }

    public double getVersion() {
        try {
            return Double.parseDouble(this.getAttribute(ATTRIBUTE_VERSION));
        }
        catch (Exception e) {
            return 1.0;
        }
    }

    public int getBuildnumber() {
        try {
            return Integer.parseInt(this.getAttribute(ATTRIBUTE_BUILDNUMBER));
        }
        catch (Exception e) {
            return 1;
        }
    }

    public String getBuildDate() {
        try {
            return this.getAttribute(ATTRIBUTE_BUILDDATE);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

